//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create OCSP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define OCSP_REQ_FILE "ocsp_req.bin"
#define CHECK_CERT    "cmp_ra.cer"
#define CA_CERT       "ca.cer"
#define MY_CERT       "cmp_ra.cer"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
unsigned char CA  [8196];
unsigned char MY  [8196];
//------------------------------------------------------------------------------
//    
// :
// 1.  OCSP     
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,hExpKey=0;
 DWORD len,sz=0,sa=0,sm=0;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   
 if (getFileLen(CHECK_CERT,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CHECK_CERT,Cert,sz)) {printf("readFile error\r\n");   return 1;}
 //    ( )
 if (!getFileLen(CA_CERT,  &sa))
   if (readFile  (CA_CERT,CA,sa)) {printf("readFile error\r\n");   return 1;}
 //    ( )
 if (!getFileLen(MY_CERT,  &sm))
   if (readFile  (MY_CERT,MY,sm)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //   
 if (!CPImportKey(hProv,Cert,sz,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    ,   , ..   
 //   keyIdentifier
 if (sa>0) {
   if (!CPSetKeyParam(hProv,hKey,KP_CERTIFICATE_CA,CA,0)) {
     printf("CPSetKeyParam KP_CERTIFICATE_CA Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
 }
 //     ,   , ..
 //     (requestorName)
 if (sm>0) {
   if (!CPImportKey(hProv,MY,sm,0,0,&hExpKey)) {
     printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
 } 
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,hKey,hExpKey,PUBLICKEYBLOB_OCSP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_OCSP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(OCSP_REQ_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,hExpKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
